<?php
session_start();
if (!isset($_SESSION['correo']) || !in_array($_SESSION['rol'], ['usuario', 'admin'])) {
  header("Location: login.php");
  exit;
}

$pdo = new PDO("mysql:host=localhost;dbname=masterc2_crud_visitas;charset=utf8mb4", "masterc2_blmg", "@l0nzo30");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$exito = isset($_GET['exito']) ? true : false;
$busqueda = $_GET['buscar'] ?? '';

if ($_SESSION['rol'] === 'usuario') {
  // Usuarios ven solo sus propias visitas
  $stmt = $pdo->prepare("SELECT * FROM visitas WHERE kam = ? AND (ruc LIKE ? OR nombre_comercial LIKE ? OR producto LIKE ?) ORDER BY fecha DESC");
  $stmt->execute([$_SESSION['nombre'], "%$busqueda%", "%$busqueda%", "%$busqueda%"]);
  $visitas = $stmt->fetchAll(PDO::FETCH_ASSOC);

} elseif ($_SESSION['rol'] === 'admin') {
  if ($_SESSION['correo'] === 'alonso.reyes@grupoblmg.com') {
    // Alonso ve todas las visitas
    if ($busqueda) {
      $stmt = $pdo->prepare("SELECT * FROM visitas WHERE ruc LIKE ? OR nombre_comercial LIKE ? OR producto LIKE ? ORDER BY fecha DESC");
      $stmt->execute(["%$busqueda%", "%$busqueda%", "%$busqueda%"]);
    } else {
      $stmt = $pdo->query("SELECT * FROM visitas ORDER BY fecha DESC");
    }
    $visitas = $stmt->fetchAll(PDO::FETCH_ASSOC);

  } else {
    // Otros admins ven solo visitas de usuarios de su misma región
    $stmt = $pdo->prepare("
      SELECT v.* FROM visitas v
      JOIN usuarios u ON v.kam = u.nombre
      WHERE u.region = ? AND (v.ruc LIKE ? OR v.nombre_comercial LIKE ? OR v.producto LIKE ?)
      ORDER BY v.fecha DESC
    ");
    $stmt->execute([$_SESSION['region'], "%$busqueda%", "%$busqueda%", "%$busqueda%"]);
    $visitas = $stmt->fetchAll(PDO::FETCH_ASSOC);
  }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>📋 Panel de Prospección</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
  * { box-sizing: border-box; }
  body {
    font-family: 'Segoe UI', sans-serif;
    background-color: #f4f4f4;
    padding: 20px;
    margin: 0;
  }
  h2 { margin-bottom: 10px; color: #333; }
  p { margin-bottom: 20px; color: #555; }

  .nuevo-btn, .buscar-btn, .logout-btn {
    background: #007bff;
    color: white;
    padding: 10px 20px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    margin-bottom: 20px;
  }
  .logout-btn { background: #dc3545; float: right; }

  .mensaje-exito {
    background-color: #d4edda;
    color: #155724;
    padding: 12px;
    border-radius: 6px;
    margin-bottom: 20px;
    text-align: center;
  }

  .busqueda-form {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
    margin-bottom: 20px;
  }
  .busqueda-form input {
    flex: 1;
    padding: 10px;
    border: 1px solid #ccc;
    border-radius: 6px;
    font-size: 14px;
  }
  .busqueda-form button {
    background: #007bff;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 6px;
    font-weight: bold;
    cursor: pointer;
  }

  #vistaTabla {
    display: block;
    overflow-x: auto;
  }
  #vistaTarjeta {
    display: none;
  }

  table {
    width: 100%;
    border-collapse: collapse;
    background: white;
    box-shadow: 0 0 5px rgba(0,0,0,0.1);
    font-size: 13px;
  }
  th, td {
    padding: 8px 10px;
    border: 1px solid #ddd;
    text-align: left;
    vertical-align: top;
    word-break: break-word;
  }
  th {
    background: #eee;
    font-weight: bold;
    color: #333;
  }

  .card {
    background: white;
    border-radius: 10px;
    box-shadow: 0 0 5px rgba(0,0,0,0.1);
    padding: 15px;
    margin-bottom: 20px;
  }
  .card h4 {
    margin: 0 0 10px;
    color: #007bff;
  }
  .card p {
    margin: 4px 0;
    font-size: 14px;
    color: #333;
  }

  .edit-btn {
    background: #ffc107;
    color: black;
    border: none;
    padding: 6px 12px;
    border-radius: 6px;
    cursor: pointer;
  }
  .delete-btn {
    background: #dc3545;
    color: white;
    border: none;
    padding: 6px 12px;
    border-radius: 6px;
    cursor: pointer;
  }

  .modal {
    display: none;
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background: rgba(0,0,0,0.5);
    justify-content: center;
    align-items: center;
    z-index: 999;
  }
  .modal-content {
    background: white;
    padding: 20px;
    border-radius: 10px;
    width: 95%;
    max-width: 800px;
    max-height: 90vh;
    overflow-y: auto;
  }

  .form-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
  }
  .form-group {
    display: flex;
    flex-direction: column;
  }
  .form-group label {
    font-weight: bold;
    margin-bottom: 5px;
    color: #555;
  }
  .form-group input,
  .form-group select,
  .form-group textarea {
    padding: 10px;
    border: 1px solid #ccc;
    border-radius: 6px;
    font-size: 14px;
  }

  .form-actions {
    text-align: center;
    margin-top: 20px;
  }
  .form-actions button {
    background-color: #007bff;
    color: white;
    padding: 12px 25px;
    border: none;
    border-radius: 6px;
    font-size: 16px;
    cursor: pointer;
  }

  .cerrar-btn {
    background: #dc3545;
    color: white;
    border: none;
    padding: 8px 12px;
    border-radius: 4px;
    float: right;
    cursor: pointer;
    margin-bottom: 10px;
  }

  #rucMensaje {
    font-size: 13px;
    margin-top: 5px;
  }

  .admin-home-btn {
    display: inline-block;
    background: #28a745;
    color: white;
    padding: 10px 20px;
    border-radius: 6px;
    text-decoration: none;
    font-weight: bold;
    margin-bottom: 20px;
  }

  .descargar-wrapper {
    text-align: left;
    margin-bottom: 12px;
    margin-top: 8px;
  }
  .descargar-btn {
    background-color: #2c89e8;
    color: white;
    padding: 9px 14px;
    border: none;
    border-radius: 6px;
    font-size: 14px;
    cursor: pointer;
    transition: background-color 0.3s ease;
  }
  .descargar-btn:hover {
    background-color: #1f6fc1;
  }

  @media (max-width: 768px) {
    #vistaTabla { display: none; }
    #vistaTarjeta { display: block; }
    .form-grid { grid-template-columns: 1fr; }
    .nuevo-btn, .form-actions button {
      width: 100%;
      margin-bottom: 10px;
    }
    .logout-btn {
      float: none;
      display: block;
      margin: 0 auto;
    }
    .admin-home-btn {
      position: fixed;
      bottom: 20px;
      right: 20px;
      background: #28a745;
      padding: 14px;
      border-radius: 50%;
      font-size: 24px;
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
      z-index: 1000;
      text-align: center;
      width: 50px;
      height: 50px;
      line-height: 22px;
      color: transparent;
      overflow: hidden;
      white-space: nowrap;
    }
    .admin-home-btn::before {
      content: "🏠";
      color: white;
      font-size: 24px;
      position: absolute;
      left: 50%;
      top: 50%;
      transform: translate(-50%, -50%);
    }
  }
</style>
</head>
<body>
  <button class="logout-btn" onclick="confirmarLogout()">🔒 Cerrar sesión</button>
  <?php if ($_SESSION['rol'] === 'usuario'): ?>
    <a href="usuario_home.php" class="admin-home-btn">⬅️ Volver al menú</a>
  <?php endif ?>
  <?php if ($_SESSION['rol'] === 'admin' && $_SESSION['correo'] === 'alonso.reyes@grupoblmg.com'): ?>
    <a href="admin_home.php" class="admin-home-btn">⬅️ Volver al menú</a>
  <?php endif ?>

  <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
    <h2>📋 Panel de Prospección</h2>
  </div>
  <p>👋 Hola <?= htmlspecialchars($_SESSION['nombre']) ?>, bienvenido al panel.</p>

  <?php if ($exito): ?>
    <div class="mensaje-exito">✅ Prospeccion registrada correctamente.</div>
  <?php endif ?>

  <form method="GET" class="busqueda-form">
    <input type="text" name="buscar" placeholder="Buscar por RUC, nombre o producto" value="<?= htmlspecialchars($busqueda) ?>">
    <button type="submit">🔍 Buscar</button>
  </form>

  <div class="descargar-wrapper">
    <form method="GET" action="descargar_visitas.php" style="display: inline;">
      <?php if (isset($_GET['buscar'])): ?>
        <input type="hidden" name="buscar" value="<?= htmlspecialchars($_GET['buscar']) ?>">
      <?php endif ?>
      <?php if (isset($_GET['kam'])): ?>
        <input type="hidden" name="kam" value="<?= htmlspecialchars($_GET['kam']) ?>">
      <?php endif ?>
      <button type="submit" class="descargar-btn">📥 Descargar visitas</button>
    </form>
  </div>

  <?php if ($_SESSION['rol'] === 'usuario'): ?>
    <button class="nuevo-btn" onclick="abrirModal()">➕ Nuevo registro</button>
  <?php endif ?>

  <div id="vistaTabla">
    <table>
      <thead>
        <tr>
          <th>Fecha</th><th>KAM</th><th>RUC</th><th>Nombre Comercial</th><th>Giro</th><th>Gestión</th><th>Etapa</th><th>Tipificación</th><th>Producto</th><th>Valor Potencial</th><th>Mes Cierre</th><th>Comentario</th><th>Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($visitas as $v): ?>
          <tr>
            <td><?= $v['fecha'] ?></td>
            <td><?= htmlspecialchars($v['kam']) ?></td>
            <td><?= $v['ruc'] ?></td>
            <td><?= htmlspecialchars($v['nombre_comercial']) ?></td>
            <td><?= htmlspecialchars($v['giro']) ?></td>
            <td><?= $v['gestion'] ?></td>
            <td><?= $v['etapa'] ?></td>
            <td><?= $v['tipificacion'] ?></td>
            <td><?= $v['producto'] ?></td>
            <td><?= $v['valor_potencial'] ?></td>
            <td><?= $v['mes_cierre'] ?></td>
            <td><?= htmlspecialchars($v['comentario']) ?></td>
            <td class="acciones">
              <?php if (in_array($_SESSION['rol'], ['usuario', 'admin'])): ?>
                <form method="POST" action="eliminar_visita.php" onsubmit="return confirm('¿Eliminar esta visita?')">
                  <input type="hidden" name="id" value="<?= $v['id'] ?>">
                  <button class="delete-btn">🗑️</button>
                </form>
                <button class="edit-btn" onclick='abrirModalEditar(<?= json_encode($v, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP) ?>)'>✏️</button>
              <?php endif ?>
            </td>
          </tr>
        <?php endforeach ?>
      </tbody>
    </table>
  </div>

  <div id="vistaTarjeta">
    <?php foreach ($visitas as $v): ?>
      <div class="card">
        <h4><?= htmlspecialchars($v['nombre_comercial']) ?> (<?= $v['ruc'] ?>)</h4>
        <p><strong>Fecha:</strong> <?= $v['fecha'] ?></p>
        <p><strong>KAM:</strong> <?= htmlspecialchars($v['kam']) ?></p>
        <p><strong>Giro:</strong> <?= htmlspecialchars($v['giro']) ?></p>
        <p><strong>Gestión:</strong> <?= $v['gestion'] ?></p>
        <p><strong>Etapa:</strong> <?= $v['etapa'] ?></p>
        <p><strong>Tipificación:</strong> <?= $v['tipificacion'] ?></p>
        <p><strong>Producto:</strong> <?= $v['producto'] ?></p>
        <p><strong>Valor Potencial:</strong> <?= $v['valor_potencial'] ?></p>
        <p><strong>Mes Cierre:</strong> <?= $v['mes_cierre'] ?></p>
        <p><strong>Comentario:</strong> <?= htmlspecialchars($v['comentario']) ?></p>
        <?php if (in_array($_SESSION['rol'], ['usuario', 'admin'])): ?>
          <div class="acciones">
            <form method="POST" action="eliminar_visita.php" onsubmit="return confirm('¿Eliminar esta visita?')" style="display:inline;">
              <input type="hidden" name="id" value="<?= $v['id'] ?>">
              <button class="delete-btn">🗑️ Eliminar</button>
            </form>
            <button class="edit-btn" onclick='abrirModalEditar(<?= json_encode($v, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP) ?>)'>✏️ Editar</button>
          </div>
        <?php endif ?>
      </div>
    <?php endforeach ?>
  </div>

  <?php if (in_array($_SESSION['rol'], ['usuario', 'admin'])): ?>
    <div class="modal" id="modal">
      <div class="modal-content">
        <button class="cerrar-btn" onclick="cerrarModal()">✖</button>
        <h3 id="modalTitulo">📝 Registro de Visita</h3>
        <form method="POST" id="formVisita">
          <input type="hidden" name="id" id="visitaId">
          <div class="form-grid">
            <div class="form-group"><label>Fecha</label><input type="date" name="fecha" required></div>
            <div class="form-group"><label>RUC del cliente</label><input type="text" name="ruc" required><div id="rucMensaje"></div></div>
            <div class="form-group"><label>Nombre comercial</label><input type="text" name="nombre_comercial" required></div>
            <div class="form-group"><label>Giro del negocio</label><input type="text" name="giro" required></div>
            <div class="form-group"><label>Gestión</label>
              <select name="gestion" required>
                <option value="captura nueva">Captura nueva</option>
                <option value="captura add">Captura add</option>
                <option value="migracion">Migración</option>
              </select>
            </div>
            <div class="form-group"><label>Etapa</label>
              <select name="etapa" required>
                <option value="10% - Prospección - Hay oportunidad">10% - Prospección - Hay oportunidad</option>
                <option value="25% - Oportunidad">25% - Oportunidad</option>
                <option value="50% - Negociación (Propuesta enviada)">50% - Negociación (Propuesta enviada)</option>
                <option value="75% - Pre Cierre (Si verbal)">75% - Pre Cierre (Si verbal)</option>
                <option value="100% - Cierre">100% - Cierre</option>
              </select>
            </div>
            <div class="form-group"><label>Tipificación</label>
              <select name="tipificacion" required>
                <option value="ACEPTA">Acepta</option>
                <option value="EN PROCESO">En proceso</option>
                <option value="NO ACEPTA">No acepta</option>
              </select>
            </div>
                        <div class="form-group"><label>Producto</label>
              <select name="producto" required>
                <option value="POS">POS</option>
                <option value="ARISALE">ARISALE</option>
                <option value="IBK">IBK</option>
                <option value="IZI ONLINE">IZI ONLINE</option>
              </select>
            </div>
            <div class="form-group"><label>Valor potencial</label>
              <input type="text" name="valor_potencial" placeholder="Ej. 3000 a más">
            </div>
            <div class="form-group"><label>Mes de cierre estimado</label>
              <input type="month" name="mes_cierre">
            </div>
            <div class="form-group full-width"><label>Comentario adicional</label>
              <textarea name="comentario" rows="3" placeholder="Escribe aquí..."></textarea>
            </div>
          </div>
          <div class="form-actions">
            <button type="submit">✅ Guardar</button>
          </div>
        </form>
      </div>
    </div>
  <?php endif ?>

 <script>
  function abrirModal() {
    document.getElementById('formVisita').action = 'registrar_visita.php';
    document.getElementById('formVisita').reset();
    document.getElementById('visitaId').value = '';
    document.getElementById('modalTitulo').textContent = '📝 Registro de Visita';
    document.getElementById('modal').style.display = 'flex';
  }

  function abrirModalEditar(data) {
    document.getElementById('formVisita').action = 'actualizar_visita.php';
    document.getElementById('visitaId').value = data.id;
    document.querySelector('input[name="fecha"]').value = data.fecha;
    document.querySelector('input[name="ruc"]').value = data.ruc;
    document.querySelector('input[name="nombre_comercial"]').value = data.nombre_comercial;
    document.querySelector('input[name="giro"]').value = data.giro;
    document.querySelector('select[name="gestion"]').value = data.gestion;
    document.querySelector('select[name="etapa"]').value = data.etapa;
    document.querySelector('select[name="tipificacion"]').value = data.tipificacion;
    document.querySelector('select[name="producto"]').value = data.producto;
    document.querySelector('input[name="valor_potencial"]').value = data.valor_potencial;
    document.querySelector('input[name="mes_cierre"]').value = data.mes_cierre;
    document.querySelector('textarea[name="comentario"]').value = data.comentario;
    document.getElementById('modalTitulo').textContent = '✏️ Editar Visita';
    document.getElementById('modal').style.display = 'flex';
  }

  function cerrarModal() {
    document.getElementById('modal').style.display = 'none';
  }

  function confirmarLogout() {
    if (confirm("¿Estás seguro de cerrar sesión?")) {
      window.location.href = "logout.php";
    }
  }

  // Validación de RUC/DNI
  const rucInput = document.querySelector('input[name="ruc"]');
  rucInput.addEventListener('input', function () {
    const valor = this.value.trim();
    const mensaje = document.getElementById('rucMensaje');

    if (valor.length === 8) {
      this.style.borderColor = '#28a745';
      mensaje.textContent = '✅ Esto es un DNI válido';
      mensaje.style.color = '#28a745';
    } else if (valor.length === 11 && (/^10|^20|^17|^15/.test(valor))) {
      this.style.borderColor = '#007bff';
      mensaje.textContent = '✅ Esto es un RUC válido';
      mensaje.style.color = '#007bff';
    } else {
      this.style.borderColor = 'red';
      mensaje.textContent = '⚠️ Debe ser un DNI (8 dígitos) o RUC (11 dígitos)';
      mensaje.style.color = 'red';
    }
  });

  // Validación de valor potencial
  const valorInput = document.querySelector('input[name="valor_potencial"]');
  valorInput.addEventListener('input', function () {
    const valor = this.value.trim();
    const mensaje = document.getElementById('valorMensaje') || document.createElement('div');

    mensaje.id = 'valorMensaje';
    mensaje.style.fontSize = '13px';
    mensaje.style.marginTop = '5px';
    this.parentNode.appendChild(mensaje);

    if (/^\d+$/.test(valor)) {
      this.style.borderColor = '#28a745';
      mensaje.textContent = '✅ Valor válido';
      mensaje.style.color = '#28a745';
    } else {
      this.style.borderColor = 'red';
      mensaje.textContent = '⚠️ Solo se permiten números enteros positivos';
      mensaje.style.color = 'red';
    }
  });
</script>
</body>
               
</html>
