<?php
session_start();
if (!isset($_SESSION['correo']) || !in_array($_SESSION['rol'], ['usuario', 'admin'])) {
  header("Location: login.php");
  exit;
}

$pdo = new PDO("mysql:host=localhost;dbname=masterc2_crud_visitas;charset=utf8mb4", "masterc2_blmg", "@l0nzo30");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$exito = isset($_GET['exito']) ? true : false;
$busqueda = $_GET['buscar'] ?? '';

if ($_SESSION['rol'] === 'usuario') {
  // Usuarios ven solo sus propios recorridos
  $stmt = $pdo->prepare("SELECT * FROM recorrido WHERE kam = ? AND (ruc LIKE ? OR nombre_comercial LIKE ? OR direccion LIKE ?) ORDER BY fecha_visita DESC");
  $stmt->execute([$_SESSION['nombre'], "%$busqueda%", "%$busqueda%", "%$busqueda%"]);
  $recorridos = $stmt->fetchAll(PDO::FETCH_ASSOC);

} elseif ($_SESSION['rol'] === 'admin') {
  if ($_SESSION['correo'] === 'alonso.reyes@grupoblmg.com') {
    // Alonso ve todos los recorridos
    if ($busqueda) {
      $stmt = $pdo->prepare("SELECT * FROM recorrido WHERE ruc LIKE ? OR nombre_comercial LIKE ? OR direccion LIKE ? ORDER BY fecha_visita DESC");
      $stmt->execute(["%$busqueda%", "%$busqueda%", "%$busqueda%"]);
    } else {
      $stmt = $pdo->query("SELECT * FROM recorrido ORDER BY fecha_visita DESC");
    }
    $recorridos = $stmt->fetchAll(PDO::FETCH_ASSOC);

  } else {
    // Otros admins ven solo recorridos de usuarios de su misma región
    $stmt = $pdo->prepare("
      SELECT r.* FROM recorrido r
      JOIN usuarios u ON r.kam = u.nombre
      WHERE u.region = ? AND (r.ruc LIKE ? OR r.nombre_comercial LIKE ? OR r.direccion LIKE ?)
      ORDER BY r.fecha_visita DESC
    ");
    $stmt->execute([$_SESSION['region'], "%$busqueda%", "%$busqueda%", "%$busqueda%"]);
    $recorridos = $stmt->fetchAll(PDO::FETCH_ASSOC);
  }
}

// ✅ En tu HTML puedes mostrar el campo así:
// <td><?= htmlspecialchars($r['tipo_visita']) ?></td>
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>📍 Panel de Recorrido</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    * { box-sizing: border-box; }
    body { font-family: 'Segoe UI', sans-serif; background-color: #f4f4f4; padding: 20px; margin: 0; }
    h2 { margin-bottom: 10px; color: #333; }
    p { margin-bottom: 20px; color: #555; }
    .nuevo-btn, .buscar-btn, .logout-btn {
      background: #007bff; color: white; padding: 10px 20px; border: none;
      border-radius: 6px; cursor: pointer; margin-bottom: 20px;
    }
    .logout-btn { background: #dc3545; float: right; }
    .mensaje-exito {
      background-color: #d4edda; color: #155724; padding: 12px;
      border-radius: 6px; margin-bottom: 20px; text-align: center;
    }
    .busqueda-form {
      display: flex; gap: 10px; flex-wrap: wrap; margin-bottom: 20px;
    }
    .busqueda-form input {
      flex: 1; padding: 10px; border: 1px solid #ccc; border-radius: 6px; font-size: 14px;
    }
    .busqueda-form button {
      background: #007bff; color: white; border: none; padding: 10px 20px;
      border-radius: 6px; font-weight: bold; cursor: pointer;
    }
    #vistaTabla { display: block; overflow-x: auto; }
    #vistaTarjeta { display: none; }
    table {
      width: 100%; border-collapse: collapse; background: white;
      box-shadow: 0 0 5px rgba(0,0,0,0.1);
    }
    th, td {
      padding: 10px; border: 1px solid #ddd; text-align: left; word-break: break-word;
    }
    th { background: #eee; }
    .card {
      background: white; border-radius: 10px; box-shadow: 0 0 5px rgba(0,0,0,0.1);
      padding: 15px; margin-bottom: 20px;
    }
    .card h4 { margin: 0 0 10px; color: #007bff; }
    .card p { margin: 4px 0; font-size: 14px; color: #333; }
    .edit-btn { background: #ffc107; color: black; border: none; padding: 6px 12px; border-radius: 6px; cursor: pointer; }
    .delete-btn { background: #dc3545; color: white; border: none; padding: 6px 12px; border-radius: 6px; cursor: pointer; }
    .modal {
      display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%;
      background: rgba(0,0,0,0.5); justify-content: center; align-items: center; z-index: 999;
    }
    .modal-content {
      background: white; padding: 20px; border-radius: 10px; width: 95%;
      max-width: 800px; max-height: 90vh; overflow-y: auto;
    }
    .form-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
    .form-group { display: flex; flex-direction: column; }
    .form-group label { font-weight: bold; margin-bottom: 5px; color: #555; }
    .form-group input, .form-group select, .form-group textarea {
      padding: 10px; border: 1px solid #ccc; border-radius: 6px; font-size: 14px;
    }
    .form-actions { text-align: center; margin-top: 20px; }
    .form-actions button {
      background-color: #007bff; color: white; padding: 12px 25px; border: none;
      border-radius: 6px; font-size: 16px; cursor: pointer;
    }
    .cerrar-btn {
      background: #dc3545; color: white; border: none; padding: 8px 12px;
      border-radius: 4px; float: right; cursor: pointer; margin-bottom: 10px;
    }
    #rucMensaje { font-size: 13px; margin-top: 5px; }
    @media (max-width: 768px) {
      #vistaTabla { display: none; }
      #vistaTarjeta { display: block; }
      .form-grid { grid-template-columns: 1fr; }
      .nuevo-btn, .form-actions button {
        width: 100%; margin-bottom: 10px;
      }
      .logout-btn { float: none; display: block; margin: 0 auto; }
    }
    
    .admin-home-btn {
  display: inline-block;
  background: #28a745;
  color: white;
  padding: 10px 20px;
  border-radius: 6px;
  text-decoration: none;
  font-weight: bold;
  margin-bottom: 20px;
}

@media (max-width: 768px) {
  .admin-home-btn {
    position: fixed;
    bottom: 20px;
    right: 20px;
    background: #28a745;
    padding: 14px;
    border-radius: 50%;
    font-size: 20px;
    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    z-index: 1000;
    text-align: center;
    width: 50px;
    height: 50px;
    line-height: 22px;
  }
  .admin-home-btn::after {
    content: "🏠";
  }
  .admin-home-btn:hover {
    background: #218838;
  }
}

.descargar-wrapper {
  text-align: left;
  margin-bottom: 12px; /* Espacio justo antes de la tabla */
  margin-top: 8px;     /* Espacio si hay algo arriba */
}

.descargar-btn {
  background-color: #2c89e8;
  color: white;
  padding: 9px 14px;
  border: none;
  border-radius: 6px;
  font-size: 14px;
  cursor: pointer;
  transition: background-color 0.3s ease;
}

.descargar-btn:hover {
  background-color: #1f6fc1;
}

.descargar-container {
  text-align: center;
  margin-bottom: 30px; /* Espacio entre el botón y la tabla */
  margin-top: 10px;    /* Espacio si hay algo arriba */
}



  </style>
</head>

<body>
  <button class="logout-btn" onclick="confirmarLogout()">🔒 Cerrar sesión</button>
  <?php if ($_SESSION['rol'] === 'usuario'): ?>
    <a href="usuario_home.php" class="admin-home-btn">⬅️ Volver al menú</a>
  <?php endif ?>
  <?php if ($_SESSION['rol'] === 'admin' && $_SESSION['correo'] === 'alonso.reyes@grupoblmg.com'): ?>
    <a href="admin_home.php" class="admin-home-btn">⬅️ Volver al menú</a>
  <?php endif ?>

  <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
    <h2>📍 Panel Recorrido</h2>
  </div>
  <p>👋 Hola <?= htmlspecialchars($_SESSION['nombre']) ?>, bienvenido al panel.</p>

  <?php if ($exito): ?>
    <div class="mensaje-exito">✅ Recorrido registrado correctamente.</div>
  <?php endif ?>

  <form method="GET" class="busqueda-form">
    <input type="text" name="buscar" placeholder="Buscar por RUC, nombre o dirección" value="<?= htmlspecialchars($busqueda) ?>">
    <button type="submit">🔍 Buscar</button>
  </form>

  <div class="descargar-wrapper">
    <form method="GET" action="descargar_recorrido.php" style="display: inline;">
      <?php if (isset($_GET['buscar'])): ?>
        <input type="hidden" name="buscar" value="<?= htmlspecialchars($_GET['buscar']) ?>">
      <?php endif ?>
      <?php if (isset($_GET['kam'])): ?>
        <input type="hidden" name="kam" value="<?= htmlspecialchars($_GET['kam']) ?>">
      <?php endif ?>
      <button type="submit" class="descargar-btn">📥 Descargar recorridos</button>
    </form>
  </div>

  <?php if ($_SESSION['rol'] === 'usuario'): ?>
    <button class="nuevo-btn" onclick="abrirModal()">➕ Nuevo registro</button>
  <?php endif ?>

  <div id="vistaTabla">
    <table>
      <thead>
        <tr>
          <th>Fecha</th><th>KAM</th><th>RUC</th><th>Nombre Comercial</th><th>Tipo Visita</th><th>Dirección</th><th>Distrito</th><th>Oportunidad</th><th>Comentario</th><th>Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($recorridos as $r): ?>
          <tr>
            <td><?= $r['fecha_visita'] ?></td>
            <td><?= htmlspecialchars($r['kam']) ?></td>
            <td><?= $r['ruc'] ?></td>
            <td><?= htmlspecialchars($r['nombre_comercial']) ?></td>
            <td><?= htmlspecialchars($r['tipo_visita']) ?></td>
            <td><?= htmlspecialchars($r['direccion']) ?></td>
            <td><?= htmlspecialchars($r['distrito']) ?></td>
            <td><?= $r['oportunidad_cliente'] ?></td>
            <td><?= htmlspecialchars($r['comentarios_finales']) ?></td>
            <td class="acciones">
              <?php if (in_array($_SESSION['rol'], ['usuario', 'admin'])): ?>
                <form method="POST" action="eliminar_recorrido.php" onsubmit="return confirm('¿Eliminar este recorrido?')">
                  <input type="hidden" name="id" value="<?= $r['id'] ?>">
                  <button class="delete-btn">🗑️</button>
                </form>
                <button class="edit-btn" onclick='abrirModalEditar(<?= json_encode($r, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP) ?>)'>✏️</button>
              <?php endif ?>
            </td>
          </tr>
        <?php endforeach ?>
      </tbody>
    </table>
  </div>

  <div id="vistaTarjeta">
    <?php foreach ($recorridos as $r): ?>
      <div class="card">
        <h4><?= htmlspecialchars($r['nombre_comercial']) ?> (<?= $r['ruc'] ?>)</h4>
        <p><strong>Fecha:</strong> <?= $r['fecha_visita'] ?></p>
        <p><strong>KAM:</strong> <?= htmlspecialchars($r['kam']) ?></p>
        <p><strong>Tipo Visita:</strong> <?= htmlspecialchars($r['tipo_visita']) ?></p>
        <p><strong>Dirección:</strong> <?= htmlspecialchars($r['direccion']) ?></p>
        <p><strong>Distrito:</strong> <?= htmlspecialchars($r['distrito']) ?></p>
        <p><strong>Oportunidad:</strong> <?= $r['oportunidad_cliente'] ?></p>
        <p><strong>Comentario:</strong> <?= htmlspecialchars($r['comentarios_finales']) ?></p>
        <?php if (in_array($_SESSION['rol'], ['usuario', 'admin'])): ?>
          <div class="acciones">
            <form method="POST" action="eliminar_recorrido.php" onsubmit="return confirm('¿Eliminar este recorrido?')" style="display:inline;">
              <input type="hidden" name="id" value="<?= $r['id'] ?>">
              <button class="delete-btn">🗑️ Eliminar</button>
            </form>
            <button class="edit-btn" onclick='abrirModalEditar(<?= json_encode($r, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP) ?>)'>✏️ Editar</button>
          </div>
        <?php endif ?>
      </div>
    <?php endforeach ?>
  </div>

  <?php if (in_array($_SESSION['rol'], ['usuario', 'admin'])): ?>
    <div class="modal" id="modal">
      <div class="modal-content">
        <button class="cerrar-btn" onclick="cerrarModal()">✖</button>
        <h3 id="modalTitulo">📝 Registro de Recorrido</h3>
        <form method="POST" id="formRecorrido">
          <input type="hidden" name="id" id="recorridoId">
          <div class="form-grid">
            <div class="form-group"><label>Fecha</label><input type="date" name="fecha_visita" required></div>
            <div class="form-group"><label>RUC del cliente</label><input type="text" name="ruc" required><div id="rucMensaje"></div></div>
            <div class="form-group"><label>Nombre comercial</label><input type="text" name="nombre_comercial" required></div>
            <div class="form-group"><label>Tipo de visita</label>
              <select name="tipo_visita" required>
                <option value="">-- Selecciona --</option>
                <option value="cartera">Cartera</option>
                <option value="captura">Fuera de Cartera</option>
              </select>
            </div>
            <div class="form-group"><label>Dirección</label><input type="text" name="direccion" required></div>
            <div class="form-group"><label>Distrito</label><input type="text" name="distrito" required></div>
            <div class="form-group"><label>Oportunidad del cliente</label>
              <select name="oportunidad_cliente" required>
                <option value="COMERCIO ENCONTRADO">COMERCIO ENCONTRADO</option>
                <option value="COMERCIO FUERA DE MI ZONA">COMERCIO FUERA DE MI ZONA</option>
                <option value="COMERCIO CERRÓ OPERACIÓN">COMERCIO CERRÓ OPERACIÓN</option>
              </select>
            </div>
            <div class="form-group full-width"><label>Comentario adicional</label>
              <textarea name="comentarios_finales" rows="3" placeholder="Escribe aquí..."></textarea>
            </div>
          </div>
          <div class="form-actions">
            <button type="submit">✅ Guardar</button>
          </div>
        </form>
      </div>
    </div>
  <?php endif ?>

  <script>
    function abrirModal() {
      document.getElementById('formRecorrido').action = 'registrar_recorrido.php';
      document.getElementById('formRecorrido').reset();
      document.getElementById('recorridoId').value = '';
      document.getElementById('modalTitulo').textContent = '📝 Registro de Recorrido';
      document.getElementById('modal').style.display = 'flex';
    }

    function abrirModalEditar(data) {
    document.getElementById('formRecorrido').action = 'actualizar_recorrido.php';
    document.getElementById('recorridoId').value = data.id;
    document.querySelector('input[name="fecha_visita"]').value = data.fecha_visita;
    document.querySelector('input[name="ruc"]').value = data.ruc;
    document.querySelector('input[name="nombre_comercial"]').value = data.nombre_comercial;
    document.querySelector('select[name="tipo_visita"]').value = data.tipo_visita;
    document.querySelector('input[name="direccion"]').value = data.direccion;
    document.querySelector('input[name="distrito"]').value = data.distrito;
    document.querySelector('select[name="oportunidad_cliente"]').value = data.oportunidad_cliente;
    document.querySelector('textarea[name="comentarios_finales"]').value = data.comentarios_finales;
    document.getElementById('modalTitulo').textContent = '✏️ Editar Recorrido';
    document.getElementById('modal').style.display = 'flex';
  }

  function cerrarModal() {
    document.getElementById('modal').style.display = 'none';
  }

  function confirmarLogout() {
    if (confirm("¿Estás seguro de cerrar sesión?")) {
      window.location.href = "logout.php";
    }
  }

  const rucInput = document.querySelector('input[name="ruc"]');
  rucInput.addEventListener('input', function () {
    const valor = this.value.trim();
    const mensaje = document.getElementById('rucMensaje');

    if (valor.length === 8) {
      this.style.borderColor = '#28a745';
      mensaje.textContent = '✅ Esto es un DNI válido';
      mensaje.style.color = '#28a745';
    } else if (valor.length === 11 && (/^10|^20|^17|^15/.test(valor))) {
      this.style.borderColor = '#007bff';
      mensaje.textContent = '✅ Esto es un RUC válido';
      mensaje.style.color = '#007bff';
    } else {
      this.style.borderColor = 'red';
      mensaje.textContent = '⚠️ Debe ser un DNI (8 dígitos) o RUC (11 dígitos)';
      mensaje.style.color = 'red';
    }
  });
</script>
</body>

</html>