<?php
session_start();

$pdo = new PDO("mysql:host=localhost;dbname=masterc2_crud_visitas;charset=utf8mb4", "masterc2_blmg", "@l0nzo30");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $correo = strtolower(trim($_POST['correo']));
  $clave  = $_POST['clave'];

  $stmt = $pdo->prepare("SELECT id, nombre, correo, clave, rol, region, estado FROM usuarios WHERE LOWER(correo) = ?");
  $stmt->execute([$correo]);
  $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

  if ($usuario && password_verify($clave, $usuario['clave'])) {
    if (strtolower($usuario['estado']) !== 'activo') {
      $error = "⚠️ Tu cuenta está inactiva. Contacta al administrador.";
    } else {
      $_SESSION['id']     = $usuario['id'];
      $_SESSION['correo'] = $usuario['correo'];
      $_SESSION['rol']    = $usuario['rol'];
      $_SESSION['region'] = $usuario['region'];
      $_SESSION['nombre'] = $usuario['nombre'];

      // Redirección según rol
      $correo_normalizado = strtolower($usuario['correo']);

      if ($correo_normalizado === 'alonso.reyes@grupoblmg.com') {
        header("Location: admin_home.php");
      } elseif (in_array($usuario['rol'], ['admin', 'usuario'])) {
        header("Location: usuario_home.php");
      } else {
        $error = "⚠️ Tu rol no tiene acceso definido.";
      }
      exit;
    }
  } else {
    $error = "❌ Correo o contraseña incorrectos.";
  }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>🔐 Iniciar sesión</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    * { box-sizing: border-box; margin: 0; padding: 0; }
    body {
      font-family: Arial, sans-serif;
      background-color: #f0f2f5;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }
    .login-box {
      background: #fff;
      padding: 30px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      width: 100%;
      max-width: 400px;
    }
    h2 {
      text-align: center;
      margin-bottom: 25px;
      color: #333;
    }
    input {
      width: 100%;
      padding: 12px;
      margin-bottom: 15px;
      border: 1px solid #ccc;
      border-radius: 6px;
      font-size: 14px;
    }
    button {
      width: 100%;
      padding: 12px;
      background-color: #007bff;
      color: white;
      border: none;
      border-radius: 6px;
      font-size: 16px;
      cursor: pointer;
    }
    button:hover {
      background-color: #0056b3;
    }
    .error {
      color: red;
      text-align: center;
      margin-top: 10px;
      font-weight: bold;
    }
  </style>
</head>
<body>

  <div class="login-box">
    <h2>🔐 Iniciar sesión</h2>
    <form method="POST">
      <input type="email" name="correo" placeholder="Correo electrónico" required>
      <input type="password" name="clave" placeholder="Contraseña" required>
      <button type="submit">Acceder</button>
    </form>
    <?php if (isset($error)): ?>
      <p class="error"><?= $error ?></p>
    <?php endif ?>
  </div>

</body>
</html>