<?php
session_start();
if (!isset($_SESSION['rol'])) {
  header("Location: login.php");
  exit;
}

$pdo = new PDO("mysql:host=localhost;dbname=masterc2_crud_visitas;charset=utf8mb4", "masterc2_blmg", "@l0nzo30");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$busqueda = $_GET['buscar'] ?? '';
$kamFiltro = $_GET['kam'] ?? '';
$params = [];

if ($_SESSION['rol'] === 'usuario') {
  $sql = "SELECT * FROM recorrido WHERE kam = ?";
  $params[] = $_SESSION['nombre'];
  if ($busqueda) {
    $sql .= " AND (ruc LIKE ? OR nombre_comercial LIKE ? OR direccion LIKE ?)";
    $params[] = "%$busqueda%";
    $params[] = "%$busqueda%";
    $params[] = "%$busqueda%";
  }
} elseif ($_SESSION['rol'] === 'admin') {
  if ($_SESSION['correo'] === 'alonso.reyes@grupoblmg.com') {
    $sql = "SELECT * FROM recorrido WHERE 1";
    if ($busqueda) {
      $sql .= " AND (ruc LIKE ? OR nombre_comercial LIKE ? OR direccion LIKE ?)";
      $params[] = "%$busqueda%";
      $params[] = "%$busqueda%";
      $params[] = "%$busqueda%";
    }
    if ($kamFiltro) {
      $sql .= " AND kam = ?";
      $params[] = $kamFiltro;
    }
  } else {
    $sql = "
      SELECT r.* FROM recorrido r
      JOIN usuarios u ON r.kam = u.nombre
      WHERE u.region = ?
    ";
    $params[] = $_SESSION['region'];
    if ($busqueda) {
      $sql .= " AND (r.ruc LIKE ? OR r.nombre_comercial LIKE ? OR r.direccion LIKE ?)";
      $params[] = "%$busqueda%";
      $params[] = "%$busqueda%";
      $params[] = "%$busqueda%";
    }
  }
}

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$recorridos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Cabeceras para descarga
header('Content-Type: text/csv; charset=UTF-8');
header('Content-Disposition: attachment; filename=recorridos_exportados.csv');

// UTF-8 BOM para compatibilidad con Excel
echo "\xEF\xBB\xBF";

$output = fopen('php://output', 'w');

// Encabezados con punto y coma
fputcsv($output, [
  'Fecha Visita', 'KAM', 'RUC', 'Nombre Comercial',
  'Tipo Visita', 'Dirección', 'Distrito', 'Oportunidad Cliente', 'Comentarios Finales'
], ';');

// Datos con punto y coma y comillas
foreach ($recorridos as $r) {
  fputcsv($output, [
    $r['fecha_visita'],
    $r['kam'],
    $r['ruc'],
    $r['nombre_comercial'],
    $r['tipo_visita'],
    $r['direccion'],
    $r['distrito'],
    $r['oportunidad_cliente'],
    $r['comentarios_finales']
  ], ';', '"');
}

fclose($output);
exit;